﻿using System;
using System.ServiceModel;
using System.ServiceModel.Description;
using Microsoft.ServiceBus;
using ServiceBusUtils;
using EnergyServiceContract;

namespace NetOnewayRelayServer
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                //string serviceBusSolutionName = ServiceBusHelper.GetServiceBusSolutionName();
                //Console.Write("Your Solution Password: ");
                //string password = ServiceBusHelper.ReadPassword();
                //string issuerName = "owner";
                //string issuerKey = "wJBJaobUmarWn6kqv7QpaaRh3ttNVr3w1OjiotVEOL4=";
                //NetOnewayEnergyServiceOperationsServer server = new NetOnewayEnergyServiceOperationsServer(
                //    serviceBusSolutionName,
                //    issuerName,
                //    issuerKey,
                //    "OnewayEnergyServiceOperations",
                //   Microsoft.ServiceBus.ConnectivityMode.AutoDetect,
                //    typeof(OnewayEnergyServiceOperations),
                //    true);

                string serviceNamespaceDomain = ServiceBusHelper.GetServiceBusSolutionName();
                Uri address = ServiceBusEnvironment.CreateServiceUri("sb", serviceNamespaceDomain, "OnewayEnergyServiceOperations");

                ServiceHost host = new ServiceHost(typeof(OnewayEnergyServiceOperations), address);
                host.Open();

               
                Console.WriteLine("ServiceUri:" + address.ToString());

                Console.WriteLine("Usługa zarejestrowana do publicznego użytku.");
               NetOnewayRelayBinding binding = host.Description.Endpoints[0].Binding as NetOnewayRelayBinding;
               if (binding != null)
               {
                   Console.WriteLine("Schemat:" + binding.Scheme);
                   Console.WriteLine("Tryb zabezpieczeń:" + binding.Security.Mode);
                   Console.WriteLine("Zabezpieczenie RelayAuthType:" + binding.Security.RelayClientAuthenticationType.ToString());
                   Console.WriteLine("Zabezpieczenie Transport.ProtectionLevel:" + binding.Security.Transport.ProtectionLevel.ToString());



               }
               Console.WriteLine("Wciśnij [Enter], aby zakonczyć");
               Console.ReadLine();

               host.Close();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);

            }
        }


    }
}
